/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CStatusBar.cpp,v 1.1 1999/09/12 04:29:49 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CStatusBar.h"

_USING_PGP

// Class CStatusBar member functions

void 
CStatusBar::Create(HWND parent, PGPUInt32 id, const char *initText)
{
	pgpAssert(!WeSubclassed());
	pgpAssert(CWindow::IsWindow(parent));

	HWND	hwnd	= CreateStatusWindow(WS_CHILD | WS_VISIBLE | 
		SBARS_SIZEGRIP, initText, parent, id);

	if (IsNull(hwnd))
		THROW_ERRORS(kPGPError_Win32WindowOpFailed, GetLastError());

	Subclass(hwnd);
}
